/*-*- comment-column: 40 -*-*/
/* ipgen -- IP test packet description generator, data types and constants. 
 *
 * Author: Juergen Nickelsen <nickelsen@condat.de>
 * Copyright (C) Condat AG 2000
 * $Id: ipgen.h,v 1.3 2000/07/13 20:24:29 ni Exp $
 */

#define LLENGTH			8192	/* Maximum input line length. */
#define TOKSEP			"\n, \t" /* Token separator. */
#define DEFAULT_OUTPUT_WIDTH	8	/* Number of bytes per output line. */
#define OUTPUT_INDENT		"\t\t\t" /* Indentation of output. */
#define MIN_IP_HEADER_LENGTH	20	/* Minimum IP header length in bytes. */

#define MAX(a, b) ((a) > (b) ? (a) : (b))

/* Struct of an IP packet in non-packed form. All header fields are
 * unsigned and in host order except the addresses, which are in
 * network order.
 */
struct IP_PKT {
    char *name ;			/* Name of the packet. */
    char *comment ;			/* Comment for packet description. */
    int real_length ;			/* Physical length of packet. */
    unsigned ip_v ;			/* Protocol version. */
    unsigned ip_hl ;			/* IP header length. */
    unsigned ip_tos ;			/* Type of service. */
    unsigned ip_len ;			/* Total length of packet. */
    int has_ip_len ;			/* Non-zero if len was specified. */
    unsigned ip_id ;			/* Datagram identification. */
    unsigned ip_flags ;			/* IP flags. */
    unsigned ip_off ;			/* Fragement offset. */
    unsigned ip_ttl ;			/* Time to live. */
    unsigned ip_p ;			/* Protocol ID. */
    unsigned ip_sum ;			/* Header checksum. */
    int has_ip_sum ;			/* Non-zero if sum was specified. */
    struct in_addr ip_src ;		/* Source address. */
    struct in_addr ip_dst ;		/* Destination address. */
    union {
	struct UDP {
	    unsigned udp_sport ;	/* Source port. */
	    unsigned udp_dport ;	/* Destination port. */
	    unsigned udp_ulen ;		/* UDP length. */
	    int has_udp_ulen ;		/* Non-zero if len was specified. */
	    unsigned udp_sum ;		/* UDP checksum. */
	    int has_udp_sum ;		/* Non-zero if sum was specified. */
	} udp ;
	struct ICMP {
	    unsigned icmp_type ;	/* ICMP type. */
	    unsigned icmp_code ;	/* ICMP code. */
	    unsigned icmp_sum ;		/* Checksum. */
	    int has_icmp_sum ;		/* Non-zero if sum was specified. */
	    union {
		unsigned icmp_unused ;
		struct {
		    int has_icmp_id ;	/* Non-zero if id was specified. */
		    unsigned icmp_id ;	/* ID in echo. */
		    unsigned icmp_seq ;	/* Sequence number in echo. */
		} echo ;
	    } u ;
	} icmp ;
    } ip_payload ;
    unsigned char data[65535-28] ;	/* Payload data. */
    unsigned data_len ;			/* Length of data (not related
					 * to real_length) */
} ;


/* Shortcuts for fields in union/struct nests. */
#define udp_sport    ip_payload.udp.udp_sport
#define udp_dport    ip_payload.udp.udp_dport
#define udp_ulen     ip_payload.udp.udp_ulen
#define has_udp_ulen ip_payload.udp.has_udp_ulen
#define udp_sum      ip_payload.udp.udp_sum
#define has_udp_sum  ip_payload.udp.has_udp_sum
#define udp_data     ip_payload.udp.udp_data
#define icmp_type    ip_payload.icmp.icmp_type
#define icmp_code    ip_payload.icmp.icmp_code
#define icmp_sum     ip_payload.icmp.icmp_sum
#define has_icmp_sum ip_payload.icmp.has_icmp_sum
#define icmp_unused  ip_payload.icmp.u.icmp_unused
#define icmp_id      ip_payload.icmp.u.echo.icmp_id
#define has_icmp_id  ip_payload.icmp.u.echo.has_icmp_id
#define icmp_seq     ip_payload.icmp.u.echo.icmp_seq
#define icmp_data    ip_payload.icmp.icmp_data


extern int output_width ;

/** Print an assembled packet.
 * @param pkt_ptr  pointer to packet struct
 */
void output_packet(struct IP_PKT *pkt) ;

/** Safe strdup() function.
 * @param s   string to duplicate
 * @return    duplicated string
 */
char *ck_strdup(char *s) ;


/* EOF */
